/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class SquareTask
extends BaseTask {
    long center;
    int radius;

    public SquareTask(CompoundTag nbt) {
        super(nbt);
        this.center = nbt.m_128454_("center");
        this.radius = nbt.m_128451_("radius");
    }

    public SquareTask(String name, ResourceKey<Level> type, int genType, ChunkPos center, int radius) {
        super(name, type, genType);
        this.center = center.m_45588_();
        this.radius = radius;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.m_128356_("center", this.center);
        nbt.m_128405_("radius", this.radius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    public String getShapeName() {
        return "Square";
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return this.radius;
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.convert("Type=Square, ", builder, ChatFormatting.DARK_PURPLE);
        ITask.convert("X=" + center.f_45578_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("Z=" + center.f_45579_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("Radius=" + this.radius, builder, ChatFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        long diameter = (long)this.radius * 2L;
        return diameter * diameter;
    }

    @Override
    public ChunkProcess createTask(ServerLevel world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        ChunkPos center = new ChunkPos(this.center);
        process.init(ChunkShapeBuilder.getSquareShape(center.f_45578_, center.f_45579_, this.radius, progress), center, this.name, this.task, this.throwEvents, progress);
        return process;
    }
}

